﻿/*
 *         Progetto: Numeri distinti 1
 * 
 *           Autore: Roberto Fuligni
 *  Ultima modifica: 17/09/2018
 *  
 *      Descrizione: Determinazione degli elementi distinti
 *                   presenti in un vettore. Algoritmo non efficiente,
 *                   complessità computazionale O(n^2).
 *                   
 */

using System;
using System.Diagnostics;

namespace NumeriDistinti1
{
    class NumeriDistinti1
    {
        static void Main(string[] args)
        {
            const int MaxNumeri = 30;       // Provare con 3000, 30000 oppure 100000
            const int ValoreMin = -10;
            const int ValoreMax = 10;

            int[] a = new int[MaxNumeri];
            int[] b = new int[MaxNumeri];
            int lunB = 0;                   // Numero di elementi distinti presenti in b
            Random r = new Random(2018);
            Stopwatch watch = new Stopwatch();

            Console.WriteLine("Numeri distinti - Variante 1 con {0} numeri casuali", MaxNumeri);
            Console.WriteLine();
            Console.Write("Elementi iniziali:");
            for (int i = 0; i < MaxNumeri; i++)
            {
                a[i] = r.Next(ValoreMin, ValoreMax + 1);    // Numero casuale in [-10; 11)
                Console.Write("  {0}", a[i]);               // Rimuovere questa riga se il 
                                                            // vettore è molto lungo
            }
            Console.WriteLine();
            Console.WriteLine();

            Console.WriteLine("Determinazione degli elementi distinti...");
            watch.Start();

            for (int i = 0; i < MaxNumeri; i++)
            {
                int contaPrec = 0;
                for (int j = 0; j < i; j++)
                {
                    if (a[j] == a[i])
                        contaPrec++;
                }

                if (contaPrec == 0)
                {
                    b[lunB] = a[i];
                    lunB++;
                }
            }

            watch.Stop();
            Console.Write("Risultato:");
            for (int i = 0; i < lunB; i++)
            {
                Console.Write("  {0}", b[i]);
            }
            Console.WriteLine();
            Console.WriteLine();

            Console.WriteLine("Applicazione terminata. Tempo impiegato (ms): {0}",
            watch.ElapsedMilliseconds);

        }
    }
}
