﻿/*
 *         Progetto: Numeri distinti 3
 * 
 *           Autore: Roberto Fuligni
 *  Ultima modifica: 17/09/2018
 *  
 *      Descrizione: Determinazione degli elementi distinti
 *                   presenti in un vettore. Algoritmo efficiente e compatto,
 *                   complessità computazionale O(n).
 *                   
 */

using System;
using System.Diagnostics;
using System.Linq;

namespace NumeriDistinti3
{
    class NumeriDistinti3
    {
        static void Main(string[] args)
        {
            const int MaxNumeri = 30;       // Provare con 3000, 30000, 100000, 1000000
            const int ValoreMin = -10;
            const int ValoreMax = 10;

            int[] a = new int[MaxNumeri];
            int[] b;

            Random r = new Random(2018);
            Stopwatch watch = new Stopwatch();

            Console.WriteLine("Numeri distinti - Variante 3 con {0} numeri casuali", MaxNumeri);
            Console.WriteLine();
            Console.Write("Elementi iniziali:");
            for (int i = 0; i < MaxNumeri; i++)
            {
                a[i] = r.Next(ValoreMin, ValoreMax + 1);    // Numero casuale in [-10; 11)
                Console.Write("  {0}", a[i]);               // Rimuovere questa riga se il 
                                                            // vettore è molto lungo
            }
            Console.WriteLine();
            Console.WriteLine();

            Console.WriteLine("Determinazione degli elementi distinti...");
            watch.Start();

            b = a.Distinct().ToArray();         // Uso del metodo LINQ "Distinct"

            watch.Stop();
            Console.Write("Elementi distinti:");
            for (int i = 0; i < b.Length; i++)
            {
                Console.Write(" {0}", b[i]);
            }
            Console.WriteLine();
            Console.WriteLine();

            Console.WriteLine("Applicazione terminata. Tempo impiegato (ms): {0}",
            watch.ElapsedMilliseconds);

        }
    }
}
