/*
 *     Applicazione: Analisi UDP
 *
 *           Autore: Roberto Fuligni
 *  Ultima modifica: 07/10/2022
 *
 *      Descrizione: Visualizza la struttura di un datagramma UDP
 *                   memorizzato all'interno di un file
 */

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;

public class AnalisiUDP {
    public static void main(String[] args) {
        analizza("Dati/udp1.bin");
        analizza("Dati/udp2.bin");
    }

    public static void analizza(String file) {
        // La classe DataInputStream consente di leggere da uno stream
        // dati primitivi (char, short, int, long, ecc.) in modo
        // indipendente dalla macchina (Big Endian).

        try(var dataIn = new DataInputStream(new FileInputStream(file))) {
            int portaS = dataIn.readUnsignedShort();
            int portaD = dataIn.readUnsignedShort();
            int lunghezza = dataIn.readUnsignedShort();
            int checksum = dataIn.readUnsignedShort();

            System.out.format("Datagramma UDP (%s)%n", Paths.get(file).toAbsolutePath());
            System.out.println("======================================================================");
            System.out.format("Porta sorgente:%6d     Porta dest.:%6d%n", portaS, portaD);
            System.out.format("Lunghezza tot.:%6d        Checksum:  %04Xh%n", lunghezza, checksum);
            System.out.println("Payload:");

            while (dataIn.available() > 0)
            {
                System.out.format("%02X ", dataIn.readByte());
            }

            System.out.println();
            System.out.println("======================================================================");
            System.out.println();
        } catch (IOException e) {
            System.out.format("Errore durante l'analisi del datagramma: %s%n", e.getMessage());
        }
    }
}