/*
 *     Applicazione: Funzione Checksum
 *
 *           Autore: Roberto Fuligni
 *  Ultima modifica: 07/10/2022
 *
 *      Descrizione: Funzione per il calcolo dell'Internet Checksum
 */

public class FunzioneChecksum {
    public static void main(String[] args) {
        int[] dati5a = new int[] { 0x020A, 0xE247, 0xF4A2 };
        // Si noti l'aggiunta di un byte nell'ultimo elemento dell'array dati5b
        int[] dati5b = new int[] { 0x4E6C, 0x2319, 0x0800, 0x7D3E, 0x8300 };
        int[] dati5c = new int[] { 0x093A, 0xFFFE, 0x8765, 0xEEF1, 0x7612, 0x0A5F };
        int[] dati5d = new int[] { 0xB56D, 0x3809, 0x5FE6, 0xF7D9, 0xBAC8 };

        System.out.format("Checksum es. 5a: %04Xh%n", ic(dati5a));
        System.out.format("Checksum es. 5b: %04Xh%n", ic(dati5b));
        System.out.format("Checksum es. 5c: %04Xh%n", ic(dati5c));
        System.out.format("Checksum es. 5d: %04Xh%n", ic(dati5d));
    }

    static int ic(int[] dati) {
        int somma = 0;
        int checksum;

        for (int d : dati)
        {
            somma += d;
            if (somma > 0xFFFF)
            {
                // L'addizione ha generato un riporto sul bit più significativo.
                // Occorre aggiungere i bit di riporto al valore della somma
                somma = (somma & 0xFFFF) + (somma >> 16);
            }
        }

        // Si tolgono eventuali le eventuali cifre di riporto e le si
        // addizionano al risultato (somma in complemento alla base diminuita).
        while (somma > 0xFFFF) {
            somma = (somma & 0xFFFF) + (somma >> 16);
        }

        checksum = (~somma) & 0xFFFF;

        // Se il checksum è pari a zero, si assume il valore convenzionale FFFFh
        if (checksum == 0)
            checksum = 0xFFFF;

        return checksum;
    }
}